<?php
$slug = (string)($tenant['slug'] ?? '');
$baseTenant = base_path('/' . $slug);

// ✅ lang değişimi (select bunu gönderiyor)
if (isset($_GET['lang'])) {
  $l = (string)$_GET['lang'];
  if (in_array($l, ['tr','en'], true)) $_SESSION['lang'] = $l;

  $url = strtok($_SERVER["REQUEST_URI"], '?');
  $q = $_GET;
  unset($q['lang']);
  if (!empty($q)) $url .= '?' . http_build_query($q);
  header("Location: " . $url);
  exit;
}

// ✅ settings'ten header+tema bilgileri
$appShort = 'FT';
$appName  = (string)($GLOBALS['app']['name'] ?? 'Fatura Takip');
$showSlug = 1;
$mode     = 'system';

if (isset($GLOBALS['pdo']) && function_exists('settings_get') && !empty($tenant['id'])) {
  try {
    $s = settings_get($GLOBALS['pdo'], (int)$tenant['id']);
    if (!empty($s['app_short'])) $appShort = (string)$s['app_short'];
    if (!empty($s['app_name']))  $appName  = (string)$s['app_name'];
    if (isset($s['ui_show_slug'])) $showSlug = (int)$s['ui_show_slug'];

    if (!empty($s['theme_mode'])) $mode = (string)$s['theme_mode']; // system/light/dark
  } catch (\Throwable $e) {}
}
?>
<!doctype html>
<html lang="<?= e($_SESSION['lang'] ?? 'tr') ?>" class="h-full">
<head>
  <meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title><?= e($tenant['name'] ?? 'Panel') ?></title>
  <script src="https://cdn.tailwindcss.com"></script>
  <script>tailwind.config={darkMode:'class'}</script>
</head>

<body class="h-full bg-slate-50 text-slate-900 dark:bg-slate-950 dark:text-slate-100">
<script>
  const defaultMode = <?= json_encode($mode) ?>;
  const saved = localStorage.getItem('theme_mode');
  const mode = saved || defaultMode;
  if (mode === 'dark') document.documentElement.classList.add('dark');
  if (mode === 'light') document.documentElement.classList.remove('dark');
</script>

<div class="min-h-full">
  <!-- Topbar -->
  <header class="sticky top-0 z-40 border-b border-slate-200 bg-white/80 backdrop-blur dark:border-slate-800 dark:bg-slate-950/70">
    <div class="mx-auto flex max-w-7xl items-center justify-between px-4 py-3 sm:px-6">
      <div class="flex items-center gap-3">
        <button id="btnMobile" class="md:hidden rounded-lg border border-slate-200 px-3 py-2 text-sm dark:border-slate-800">☰</button>
        <div class="flex items-center gap-2">
<div class="h-9 w-9 rounded-xl bg-slate-900 text-white grid place-items-center font-semibold dark:bg-white dark:text-slate-900">
  <?= e($appShort) ?>
</div>
<div class="leading-tight">
  <div class="font-semibold"><?= e($appName) ?></div>
  <?php if ($showSlug): ?>
    <div class="text-xs text-slate-500 dark:text-slate-400"><?= e($slug) ?></div>
  <?php endif; ?>
</div>

          
        </div>
      </div>

      <div class="flex items-center gap-2">
        <select id="langSelect" class="rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-900">
          <option value="tr" <?= ($_SESSION['lang'] ?? 'tr')==='tr'?'selected':'' ?>>TR</option>
          <option value="en" <?= ($_SESSION['lang'] ?? 'tr')==='en'?'selected':'' ?>>EN</option>
        </select>

        <button id="themeToggle" class="rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-900">
          <span id="themeIcon">🌓</span>
        </button>

        <div class="flex items-center gap-2 rounded-xl border border-slate-200 bg-white px-3 py-2 dark:border-slate-800 dark:bg-slate-900">
          <div class="h-8 w-8 rounded-full bg-slate-200 dark:bg-slate-800"></div>
          <div class="hidden sm:block">
            <div class="text-sm font-medium"><?= e($user['name'] ?? 'User') ?></div>
            <div class="text-xs text-slate-500 dark:text-slate-400"><?= e($user['role'] ?? 'staff') ?></div>
          </div>
        </div>
      </div>
    </div>
  </header>

  <div class="mx-auto grid max-w-7xl grid-cols-1 gap-0 px-0 md:grid-cols-[260px_1fr] md:px-6">
    <!-- Sidebar -->
    <aside id="sidebar" class="fixed inset-y-0 left-0 z-50 w-[280px] -translate-x-full border-r border-slate-200 bg-white p-4 transition md:static md:z-auto md:w-auto md:translate-x-0 md:border-r md:bg-transparent md:p-0 dark:border-slate-800 dark:bg-slate-950 md:dark:bg-transparent">
      <div class="md:sticky md:top-[68px]">
        <div class="md:rounded-2xl md:border md:border-slate-200 md:bg-white md:p-3 dark:md:border-slate-800 dark:md:bg-slate-950">
          <div class="flex items-center justify-between md:hidden">
            <div class="font-semibold"><?= e(t('menu.menu')) ?></div>
            <button id="btnClose" class="rounded-lg border border-slate-200 px-3 py-2 text-sm dark:border-slate-800">✕</button>
          </div>

          <nav class="mt-3 space-y-1">
            <?php
              $nav = [
                  ['href'=>$baseTenant.'/dashboard','icon'=>'🏠','label'=>t('menu.dashboard')],
                  ['href'=>$baseTenant.'/create','icon'=>'➕','label'=>t('menu.create')],
                  ['href'=>$baseTenant.'/invoices','icon'=>'🧾','label'=>t('menu.invoices')],
                  ['href'=>$baseTenant.'/quotes','icon'=>'📄','label'=>t('menu.quotes')],
                  ['href'=>$baseTenant.'/customers','icon'=>'👥','label'=>t('menu.customers')],
                  ['href'=>$baseTenant.'/products','icon'=>'📦','label'=>t('menu.products')],
                  ['href'=>$baseTenant.'/profile','icon'=>'👤','label'=>t('menu.profile')],
                  ['href'=>$baseTenant.'/settings','icon'=>'⚙️','label'=>t('menu.settings')],
                  ['href'=>$baseTenant.'/company','icon'=>'🏢','label'=>t('menu.company')],
                  ['href'=>$baseTenant.'/trash','icon'=>'🗑️','label'=>t('menu.trash')],
              ];
              $cur = tenant_strip_prefix($GLOBALS['path'] ?? '/');
            ?>
            <?php foreach($nav as $it):
              $active = str_ends_with($it['href'], $cur) ? 'bg-slate-900 text-white dark:bg-white dark:text-slate-900' : 'hover:bg-slate-50 dark:hover:bg-slate-900/50';
            ?>
              <a href="<?= e($it['href']) ?>" class="flex items-center gap-2 rounded-xl px-3 py-2 text-sm <?= $active ?>">
                <span><?= $it['icon'] ?></span> <span><?= e($it['label']) ?></span>
              </a>
            <?php endforeach; ?>

            <div class="pt-2">
              <form method="post" action="<?= e(base_path('/logout')) ?>">
                <input type="hidden" name="csrf" value="<?= e(csrf_token()) ?>">
                <button class="w-full rounded-xl border border-slate-200 px-3 py-2 text-left text-sm text-slate-700 hover:bg-slate-50 dark:border-slate-800 dark:text-slate-200 dark:hover:bg-slate-900/50">
                  ⎋ <?= e(t('menu.logout')) ?>
                </button>
              </form>
            </div>
          </nav>
        </div>

        <div class="mt-3 hidden text-xs text-slate-500 dark:text-slate-400 md:block">
          v2 • Saf PHP
        </div>
      </div>
    </aside>

    <!-- Main -->
    <main class="px-4 py-6 sm:px-6">
      <div class="rounded-2xl border border-slate-200 bg-white p-5 dark:border-slate-800 dark:bg-slate-900">
        <?php
          $pageFile = __DIR__ . '/../panel/' . basename((string)$page) . '.php';
          if (is_file($pageFile)) require $pageFile;
          else echo "<div>Page not found</div>";
        ?>
      </div>
    </main>
  </div>
</div>

<script>
  const sidebar = document.getElementById('sidebar');
  document.getElementById('btnMobile')?.addEventListener('click', ()=> sidebar.classList.remove('-translate-x-full'));
  document.getElementById('btnClose')?.addEventListener('click', ()=> sidebar.classList.add('-translate-x-full'));

  document.getElementById('themeToggle')?.addEventListener('click', ()=>{
    document.documentElement.classList.toggle('dark');
    const isDark = document.documentElement.classList.contains('dark');
    localStorage.setItem('theme_mode', isDark ? 'dark' : 'light');
  });

  document.getElementById('langSelect')?.addEventListener('change', (e)=>{
    const v = e.target.value;
    const url = new URL(window.location.href);
    url.searchParams.set('lang', v);
    window.location.href = url.toString();
  });
</script>
</body>
</html>
